#ifndef RFDECODE_H
#define RFDECODE_H

// <<< Use Configuration Wizard in Context Menu >>>
	//<o> Select remote control module	<0=> Customize <1=> ET55 <2=> ET66 <3=> ET90
		#define		RF_remote_control_moduel	0

//********************************************************************************
//									ET55
//********************************************************************************		
		#if(RF_remote_control_moduel==1)
			#define IR_DEC_CTRL_REGS 					0xC0
			#define IR_DEC_SET_REGS 					0x95
			#define RF_HEADER1_TIME 					5000
			#define RF_HEADER2_TIME 					7800
			#define RF_STOP_TIME 						5000
			#define RF_decoding_UR_Enable 				0
			#define Remote_control_learning_function 	1
			#define	RF_DATA_LEARNING				 	13503
			#define Learning_TIME					 	10
			#define Successful_Learning_TIMES			(1)*10
			#define	RF_address_value					339
			#define	e_RF_OFF							1	
			#define	e_RF_SPEED1							1
			#define	e_RF_SPEED2							1
			#define	e_RF_SPEED3							1
			#define	e_RF_SPEED4							1
			#define	e_RF_SPEED5							0
			#define	e_RF_SPEED6							0
			#define	e_RF_SPEED7							0
			#define	e_RF_SMART							1
			#define	e_RF_1H								0
			#define	e_RF_2H								0
			#define	e_RF_3H								1
			#define	e_RF_4H								0
			#define	e_RF_6H								1	
			#define	e_RF_8H								0	
			#define	e_RF_9H								1
			#define	RF_DATA_OFF							13503
			#define	RF_DATA_SPEED1						15903
			#define	RF_DATA_SPEED2						13983
			#define	RF_DATA_SPEED3						13743
			#define	RF_DATA_SPEED4						15423
			#define	RF_DATA_SMART						13263
			#define	RF_DATA_3H							15183
			#define	RF_DATA_6H							14223
			#define	RF_DATA_9H							15663
//********************************************************************************
//									ET66
//********************************************************************************			
		#elif(RF_remote_control_moduel==2)
			#define IR_DEC_CTRL_REGS 					0xC0
			#define IR_DEC_SET_REGS 					0x15
			#define RF_HEADER1_TIME 					0
			#define RF_HEADER2_TIME 					0
			#define RF_STOP_TIME 						12000
			#define RF_decoding_UR_Enable 				0
			#define Remote_control_learning_function 	1
			#define	RF_DATA_LEARNING				 	247
			#define Learning_TIME						10
			#define Successful_Learning_TIMES			(1)*10
			#define	RF_address_value					19328
			#define	e_RF_OFF							1	
			#define	e_RF_SPEED1							1
			#define	e_RF_SPEED2							1
			#define	e_RF_SPEED3							1
			#define	e_RF_SPEED4							1
			#define	e_RF_SPEED5							0
			#define	e_RF_SPEED6							0
			#define	e_RF_SPEED7							0
			#define	e_RF_SMART							1
			#define	e_RF_1H								1
			#define	e_RF_2H								1
			#define	e_RF_3H								0
			#define	e_RF_4H								1
			#define	e_RF_6H								1	
			#define	e_RF_8H								1
			#define	e_RF_9H								0
			#define	RF_DATA_OFF							247
			#define	RF_DATA_SPEED1						254
			#define	RF_DATA_SPEED2						253
			#define	RF_DATA_SPEED3						252
			#define	RF_DATA_SPEED4						251
			#define	RF_DATA_SPEED5						250
			#define	RF_DATA_SPEED6						234
			#define	RF_DATA_SPEED7						236
			#define	RF_DATA_SMART						248
			#define	RF_DATA_1H							246
			#define	RF_DATA_2H							239
			#define	RF_DATA_4H							235
			#define	RF_DATA_6H							249
			#define	RF_DATA_8H							237
//********************************************************************************
//									ET90
//********************************************************************************
		#elif(RF_remote_control_moduel==3)
			#define IR_DEC_CTRL_REGS 					0xC0
			#define IR_DEC_SET_REGS 					0x15
			#define RF_HEADER1_TIME 					0
			#define RF_HEADER2_TIME 					0
			#define RF_STOP_TIME 						11000
			#define RF_decoding_UR_Enable 				0
			#define Remote_control_learning_function 	1
			#define	RF_DATA_LEARNING				 	247
			#define Learning_TIME						10
			#define Successful_Learning_TIMES			(1)*10
			#define	RF_address_value					19328
			#define	e_RF_OFF							1	
			#define	e_RF_SPEED1							1
			#define	e_RF_SPEED2							1
			#define	e_RF_SPEED3							1
			#define	e_RF_SPEED4							1
			#define	e_RF_SPEED5							0
			#define	e_RF_SPEED6							0
			#define	e_RF_SPEED7							0
			#define	e_RF_SMART							1
			#define	e_RF_1H								1
			#define	e_RF_2H								1
			#define	e_RF_3H								0
			#define	e_RF_4H								1
			#define	e_RF_6H								1	
			#define	e_RF_8H								1
			#define	e_RF_9H								0
			#define	RF_DATA_OFF							247
			#define	RF_DATA_SPEED1						254
			#define	RF_DATA_SPEED2						253
			#define	RF_DATA_SPEED3						252
			#define	RF_DATA_SPEED4						251
			#define	RF_DATA_SPEED5						250
			#define	RF_DATA_SPEED6						234
			#define	RF_DATA_SPEED7						236
			#define	RF_DATA_SMART						248
			#define	RF_DATA_1H							246
			#define	RF_DATA_2H							239
			#define	RF_DATA_4H							235
			#define	RF_DATA_6H							249
			#define	RF_DATA_8H							237
//********************************************************************************
//								   Customize
//********************************************************************************			
		#elif(RF_remote_control_moduel==0)
			//<h> Customize
			//<i> If you select Customize moduel,setting it.
				// <h> Set RF_DEC_CTRL
					// <o.6> RFIN_SEL <0=> RF decode data input from P0.5 / IR1 <1=> RF decode data input from P3.3 / IR2 
						#define IR_DEC_CTRL_REGS 0xC0
				// </h>

				// <h> Set RF_DEC_SET
					// <o.0..2> CLK_DIV_SEL <0=> 24MHz <1=> 16MHz <2=> 8MHz <3=> 6MHz <4=> 3MHz <5=> 2MHz 
					// <o.3..4> DIN_DB_SEL <0=> 0ns <1=> 250ns <2=> 500ns <3=> 1000ns
					// <o.5> DIN_TYP <0=> Data Type1 <1=> Data Type2
					// <i> Data Type1 = Falling to Rising edge: Duty > 50% -> Din = 0; Duty < 50% -> Din = 1
					// <i> Data Type2 = Falling to Rising edge: Duty > 50% -> Din = 1; Duty < 50% -> Din = 0
					// <o.6> DOUT_REV <0=> First input data is LSB <1=> First input data is MSB 
					// <o.7> HEADER_EN <0=> No HEADER <1=> With HEADER
						#define IR_DEC_SET_REGS 		0x15
				// </h>
				
				//<h> Remote control code set
					//<h> Head code set
					
						// <o> Set Header Zone1 time width (unit : us)   <0-32767>
								#define RF_HEADER1_TIME 		5000
								
						// <o> Set Header Zone2 time width (unit : us)   <0-32767>
								#define RF_HEADER2_TIME 		7800
					//</h>
					
					//<h> Stop code set
					
						// <o> Set stop time width (unit : us) <0-32767>
								#define RF_STOP_TIME 		5000
					//</h>
					
					//<q> RF decoding to UR Enable
						#define RF_decoding_UR_Enable 	0
					
					//<e> Learning function
						#define Remote_control_learning_function 1
						#if (Remote_control_learning_function == 1)
							//<o> Learning data values set <0-65535>
								#define	RF_DATA_LEARNING				 13503
							//<o> Set learn time(unit : sec)<0-20>
								#define Learning_TIME					 10
							
							//<o> Judge the times of successful learning(unit : 10 times)<0-20>
								#define Successful_Learning_TIMES		(1)*10
						#endif
					//</e> 
					
					//<o> RF address value set <0-65535> 
					//<i> If you use the learning function, you don't need to set the address code.
						#define	RF_address_value				54399
					
					//<h> RF data values set
						//<e>  Enable OFF Button
							#define	e_RF_OFF					1
							#if(e_RF_OFF == 1)
								//<o>  Button OFF<0-65535> 
									#define	RF_DATA_OFF			13503
							#endif
						//</e> 
						
						//<e>  Enable Speed1 Button
							#define	e_RF_SPEED1					1
							#if(e_RF_SPEED1 == 1)
								//<o>  Button speed 1<0-65535> 
									#define	RF_DATA_SPEED1		15903
							#endif
						//</e> 
						
						//<e>  Enable Speed2 Button
							#define	e_RF_SPEED2					1
							#if(e_RF_SPEED2 == 1)
								//<o>  Button speed 2<0-65535> 
									#define	RF_DATA_SPEED2		13983
							#endif
						//</e>
							
						//<e>  Enable Speed3 Button
							#define	e_RF_SPEED3					1
							#if(e_RF_SPEED3 == 1)
								//<o>  Button speed 3<0-65535> 
									#define	RF_DATA_SPEED3		13743
							#endif
						//</e>
							
						//<e>  Enable Speed4 Button
							#define	e_RF_SPEED4					1
							#if(e_RF_SPEED4 == 1)
								//<o>  Button speed 4<0-65535> 
									#define	RF_DATA_SPEED4		15423
							#endif
						//</e>
							
						//<e>  Enable Speed5 Button
							#define	e_RF_SPEED5					0
							#if(e_RF_SPEED5 == 1)
								//<o>  Button speed 5<0-65535> 
									#define	RF_DATA_SPEED5		65535
							#endif
						//</e>
							
						//<e>  Enable Speed6 Button
							#define	e_RF_SPEED6					0
							#if(e_RF_SPEED6 == 1)
								//<o>  Button speed 6<0-65535> 
									#define	RF_DATA_SPEED6		65534
							#endif
						//</e>
						
						//<e>  Enable Speed7 Button
							#define	e_RF_SPEED7					0
							#if(e_RF_SPEED7 == 1)
								//<o>  Button speed 7<0-65535> 
									#define	RF_DATA_SPEED7		65533
							#endif
						//</e>
							
						//<e>  Enable SMART Button
							#define	e_RF_SMART					1
							#if(e_RF_SMART == 1)
								//<o>  Button SMART<0-65535> 
									#define	RF_DATA_SMART		13263
							#endif
						//</e>
							
						//<e>  Enable 1H Button
							#define	e_RF_1H						0
							#if(e_RF_1H == 1)
								//<o>  Button 1H<0-65535> 
									#define	RF_DATA_1H			65532
							#endif
						//</e>
							
						//<e>  Enable 2H Button
							#define	e_RF_2H						0
							#if(e_RF_2H == 1)
								//<o>  Button 2H<0-65535> 
									#define	RF_DATA_2H			65531
							#endif
						//</e>
							
						//<e>  Enable 3H Button
							#define	e_RF_3H						1
							#if(e_RF_3H == 1)
								//<o>  Button 3H<0-65535> 
									#define	RF_DATA_3H			15183
							#endif
						//</e>
						
						//<e>  Enable 4H Button
							#define	e_RF_4H						0
							#if(e_RF_4H == 1)
								//<o>  Button 4H<0-65535> 
									#define	RF_DATA_4H			65530
							#endif
						//</e>
							
						//<e>  Enable 6H Button
							#define	e_RF_6H						1
							#if(e_RF_6H == 1)
								//<o>  Button 6H<0-65535> 
									#define	RF_DATA_6H			14223
							#endif
						//</e>
						
						//<e>  Enable 8H Button
							#define	e_RF_8H						0
							#if(e_RF_8H == 1)
								//<o>  Button 8H<0-65535> 
									#define	RF_DATA_8H			65529	
							#endif
						//</e>		

						//<e>  Enable 9H Button
							#define	e_RF_9H						1
							#if(e_RF_9H == 1)
								//<o>  Button 9H<0-65535> 
									#define	RF_DATA_9H			15663
							#endif
						//</e>
					//</h>		
				//</h>
			//</h>
		#endif
void RFLearning_mode(void);
extern void IRDecode_Init (void);

#if (Remote_control_type == dRF_Control)

typedef struct{	
	uint8	RF_Learning_Address[2];
	uint8 	RF_learning_times;
	uint16	RF_address;
	uint16	RF_data;
	
	#if (RF_decoding_UR_Enable == 1)
		uint16	RF_address_ur;
		uint16	RF_data_ur;
	#endif	
}USER_RF_Decode;


extern	USER_RF_Decode		idata 	RF_Decode;
#endif	
// <<< end of configuration section >>>
#endif